<?php

namespace App\Enum;

enum TransactionType: string
{
    case DEPOSIT = 'deposit';
    case WITHDRAW = 'withdraw';
    case PROFIT = 'profit';
    case PLAN_SUBSCRIPTION = 'plan_subscription';

    public function label(): string
    {
        return match ($this) {
            self::DEPOSIT => 'Deposit',
            self::WITHDRAW => 'Withdraw',
            self::PROFIT => 'Profit',
            self::PLAN_SUBSCRIPTION => 'Plan Subscription',
        };
    }
}
