<?php

namespace App\Enum;

enum UserAccountType: string
{
    case TRADER = 'trader';
    case INVESTOR = 'investor';

    public function label()
    {
        return match ($this) {
            self::TRADER => 'Trader',
            self::INVESTOR => 'Investor',
        };
    }

    public function badge()
    {
        return match ($this) {
            self::TRADER => 'badge bg-info-subtle text-info fs-12 p-1',
            self::INVESTOR => 'badge bg-success-subtle text-success fs-12 p-1',
        };
    }

    public function textColor()
    {
        return match ($this) {
            self::TRADER => 'text-info',
            self::INVESTOR => 'text-success',
        };
    }
}
