<?php

namespace App\Enum;

enum UserPlanStatus: string
{
    case PENDING = 'pending';
    case ACTIVE = 'active';
    case COMPLETED = 'completed';
    case CANCELLED = 'cancelled';

    public function label(): string
    {
        return match ($this) {
            self::PENDING => 'Pending',
            self::ACTIVE => 'Active',
            self::COMPLETED => 'Completed',
            self::CANCELLED => 'Cancelled',
        };
    }

    public function badge()
    {
        return match ($this) {
            self::PENDING => 'badge bg-warning-subtle text-warning fs-12 p-1',
            self::ACTIVE => 'badge bg-info-subtle text-info fs-12 p-1',
            self::COMPLETED => 'badge bg-success-subtle text-success fs-12 p-1',
            self::CANCELLED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
