<?php

function currency($currency, $type = 'symbol')
{

    $explodeCurrency = explode('-', $currency->value);

    switch ($type) {
        case 'name':
            return @$explodeCurrency[0];
            break;
        case 'code':
            return @$explodeCurrency[1];
        case 'symbol':
            return @$explodeCurrency[2];
        default:
            return @$explodeCurrency[2];
            break;
    }
}

function formatAmount($amount, $decimals = 0)
{
    return number_format($amount, $decimals);
}

function generateReferenceId($prefix = 'REF')
{
    // Uppercase prefix (default = REF)
    $prefix = strtoupper($prefix);

    // Date part (YYMMDD)
    $date = date('ymd');

    // Random unique part (6 digits)
    $random = random_int(100000, 999999);

    // Combine
    return $prefix . $date . $random;
}

function getRandomNumber($length = 2)
{
    // Define the characters to be used in the random number
    $characters = '0123456789';
    // Initialize an empty string to store the random number
    $randomNumber = '';
    // Loop to generate each digit of the random number
    for ($i = 0; $i < $length; $i++) {
        // Append a random digit to the random number
        $randomNumber .= $characters[rand(0, strlen($characters) - 1)];
    }
    // Return the generated random number
    return $randomNumber;
}

function limitText($text, $limit = 20)
{
    return str()->limit($text, $limit);
}

function formatDate($date)
{
    return date('d M Y', strtotime($date));
}

function formatTime($time)
{
    return date('h:i A', strtotime($time));
}

function formatDateTime($datetime)
{
    return date('d M Y h:i A', strtotime($datetime));
}

function uploadPathUser($path)
{
    return '/uploads/dashboard/user/' . $path . '/';
}
function uploadPathAdmin($path)
{
    return '/uploads/dashboard/admin/' . $path . '/';
}

function generateApiKey(): string
{
    return hash('sha256', Str::random(60));
}

function generateSecretKey(): string
{
    return hash('sha256', Str::random(80));
}
