<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Enum\TransactionType;
use App\Enum\TransactionStatus;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Models\PremiumSignalSubscription;

class PremiumSignalSubscriptionController extends Controller
{
    public function index()
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Premium Signal Subscriptions', 'active' => true]
        ];

        $premiumSignalSubscriptions = PremiumSignalSubscription::latest()->get();

        $data = [
            'title' => 'Premium Signal Subscriptions',
            'breadcrumbs' => $breadcrumbs,
            'premiumSignalSubscriptions' => $premiumSignalSubscriptions
        ];

        return view('dashboard.admin.premium_signal_subscription.index', $data);
    }

    public function show(string $uuid)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Premium Signal Subscriptions', 'url' => route('admin.premium.signal.subscription.index')],
            ['label' => 'Premium Signal Subscription Details', 'active' => true]
        ];

        $premiumSignalSubscription = PremiumSignalSubscription::where('uuid', $uuid)->firstOrFail();

        $data = [
            'title' => 'Premium Signal Subscription Details',
            'breadcrumbs' => $breadcrumbs,
            'premiumSignalSubscription' => $premiumSignalSubscription
        ];

        return view('dashboard.admin.premium_signal_subscription.show', $data);
    }
}
