<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\User;
use App\Enum\UserStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class UserStatusController extends Controller
{
    public function index(string $uuid)
    {
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => 'Users', 'url' => route('admin.user.index')],
            ['label' => 'User Details', 'url' => route('admin.user.show', $uuid)],
            ['label' => 'Account Status', 'active' => true]
        ];

        $user = User::where('uuid', $uuid)->firstOrFail();

        $userStatues = UserStatus::cases();

        $data = [
            'title' => 'Account Status',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'userStatues' => $userStatues
        ];

        return view('dashboard.admin.user.status.index', $data);
    }

    public function update(Request $request, string $uuid)
    {
        $request->validate([
            'status' => 'required|in:active,inactive'
        ]);

        $user = User::where('uuid', $uuid)->firstOrFail();

        try {
            DB::beginTransaction();

            $user->update([
                'status' => $request->status
            ]);

            DB::commit();
            return redirect()->route('admin.user.show', $uuid)->with('success', 'Account status updated successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error($e->getMessage());
            return redirect()->route('admin.user.status', $uuid)->with('error', config('app.messages.error'));
        }
    }
}
