<?php

namespace App\Http\Controllers\Dashboard\Master;

use App\Models\User;
use App\Enum\UserRole;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $welcomeMessage = 'Welcome' . ' ' . Auth::user()->name;

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('master.dashboard')],
            ['label' => $welcomeMessage, 'active' => true]
        ];

        $users = User::where('role', UserRole::ADMIN->value)->latest()->get();

        $data = [
            'title' => $welcomeMessage,
            'breadcrumbs' => $breadcrumbs,
            'users' => $users
        ];

        return view('dashboard.master.index', $data);
    }
}
