<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use App\Models\Trade;
use App\Models\Trader;
use Illuminate\Http\Request;
use App\Models\TraderSubscription;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CopyTradeController extends Controller
{
    public function __construct()
    {
        $this->middleware(['registeredUser', 'kycVerification']);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $search = $request->search;

        $trader = Trader::where('uuid', $search)->first();

        $user = User::where('id', Auth::id())->firstOrFail();

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => 'Copy Trade', 'active' => true]
        ];

        $data = [
            'title' => 'Copy Trade',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'trader' => $trader
        ];

        return view('dashboard.user.copy_trade.index', $data);
    }

    public function link(string $traderUUID)
    {
        try {
            $trader = Trader::where('uuid', $traderUUID)->firstOrFail();

            $user = Auth::user();

            DB::transaction(function () use ($user, $trader) {
                TraderSubscription::create([
                    'trader_id' => $trader->id,
                    'user_id' => $user->id
                ]);
            });

            return redirect()->route('user.copy.trade.subscription')->with('success', 'Account linked to trader successfully.');
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return redirect()->route('user.copy.trade.index')->with('error', 'Unable to link account to trader.');
        }
    }

    public function subscription()
    {
        $user = Auth::user();

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => 'Copy Trade', 'url' => route('user.copy.trade.index')],
            ['label' => 'Copy Trade Subscription', 'active' => true],
        ];

        $traderSubscription = TraderSubscription::with(['trader'])->where('user_id', $user->id)->first();

        $data = [
            'title' => 'Copy Trade Subscription',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'traderSubscription' => $traderSubscription
        ];

        return view('dashboard.user.copy_trade.subscription', $data);
    }

    public function unlink($traderSubscriptionUUID)
    {
        try {
            $user = Auth::user();

            $traderSubscription = TraderSubscription::where('user_id', $user->id)->where('uuid', $traderSubscriptionUUID)->firstOrFail();

            DB::transaction(function () use ($traderSubscription) {
                $traderSubscription->delete();
            });

            return redirect()->route('user.copy.trade.subscription')->with('success', 'Account unlinked to trader successfully.');
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return redirect()->route('user.copy.trade.subscription')->with('error', 'Unable to unlink account to trader.');
        }
    }
}
