<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class TransactionController extends Controller
{
    public function __construct()
    {
        $this->middleware(['registeredUser', 'kycVerification']);
    }

    public function index()
    {
        $user = Auth::user();

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => 'Transactions', 'active' => true],
        ];

        $transactions = $user->transaction()->latest()->get();

        $data = [
            'title' => 'Transactions',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'transactions' => $transactions
        ];

        return view('dashboard.user.transaction.index', $data);
    }

    public function show(string $uuid)
    {
        $user = Auth::user();
        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('user.dashboard')],
            ['label' => 'Transactions', 'url' => route('user.transaction.index')],
            ['label' => 'Transaction Details', 'active' => true],
        ];

        $transaction = $user->transaction()->where('uuid', $uuid)->firstOrFail();

        $data = [
            'title' => 'Transaction Details',
            'user' => $user,
            'breadcrumbs' => $breadcrumbs,
            'transaction' => $transaction
        ];

        return view('dashboard.user.transaction.show', $data);
    }
}
