<?php

namespace App\Http\Requests;

use App\Models\User;
use App\Enum\UserAccountMode;
use App\Enum\UserAccountType;
use Illuminate\Foundation\Http\FormRequest;

class AdminUpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $uuid = $this->route('user');
        $user = User::where('uuid', $uuid)->firstOrFail();

        return [
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . $user->id,
            'phone' => 'nullable|string|max:255',
            'gender' => 'nullable|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'password' => 'nullable|confirmed',
            'account_type' => ['nullable', 'in:' . implode(',', array_column(UserAccountType::cases(), 'value'))],
            'account_mode' => ['nullable', 'in:' . implode(',', array_column(UserAccountMode::cases(), 'value'))],
            'currency' => 'nullable|string|max:255',
            'two_factor_enabled' => 'nullable|boolean|in:1,0',
            'signal_strength' => 'nullable|numeric|min:0|max:100',
            'country' => 'nullable|string|max:255',
            'address' => 'nullable|string|max:255',
            'city' => 'nullable|string|max:255',
            'state' => 'nullable|string|max:255',
            'zip_code' => 'nullable|string|max:20',
            'id_type' => 'nullable|in:passport,driving_license,other',
            'id_front' => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
            'id_back' => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
        ];
    }
}
