<?php

namespace App\Http\Requests;

use App\Enum\SignalAction;
use App\Enum\SignalDuration;
use App\Enum\SignalType;
use Illuminate\Foundation\Http\FormRequest;

class StoreSignalRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // Must exist in markets table
            'market_id' => [
                'required',
                'integer',
                'exists:markets,id',
            ],

            // Signal category
            'type' => [
                'required',
                'string',
                'max:30',
                'in:' . implode(',', array_column(SignalType::cases(), 'value')),
            ],

            // Buy or Sell
            'action' => [
                'required',
                'string',
                'max:10',
                'in:' . implode(',', array_column(SignalAction::cases(), 'value')),
            ],

            // Quantity / units
            'unit' => [
                'required',
                'integer',
                'min:1',
            ],

            // Amount involved (asset or capital)
            'amount' => [
                'required',
                'integer',
                'min:1',
            ],

            // Duration in minutes (enum-backed)
            'duration' => [
                'required',
                'integer',
                'in:' . implode(',', array_column(SignalDuration::cases(), 'value')),
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'market_id.exists' => 'The selected market is invalid.',
            'type.in' => 'Signal type must be demo or live.',
            'action.in' => 'Action must be either buy or sell.',
            'duration.in' => 'Invalid signal duration selected.',
        ];
    }
}
