<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SwapRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'from_market_id' => [
                'required',
                'integer',
                'exists:markets,id',
                function ($attribute, $value, $fail) {
                    if ($value == $this->input('to_market_id')) {
                        $fail('Source and target markets must be different.');
                    }
                },
            ],
            'to_market_id' => [
                'required',
                'integer',
                'exists:markets,id',
                function ($attribute, $value, $fail) {
                    if ($value == $this->input('from_market_id')) {
                        $fail('Source and target markets must be different.');
                    }
                },
            ],
            'from_amount' => [
                'required',
                'numeric',
                'min:0.00000001',
                'max:999999999',
            ],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     */
    public function messages(): array
    {
        return [
            'from_market_id.required' => 'Please select a source market.',
            'from_market_id.exists' => 'The selected source market does not exist.',
            'from_market_id.integer' => 'Invalid market selection.',
            'to_market_id.required' => 'Please select a target market.',
            'to_market_id.exists' => 'The selected target market does not exist.',
            'to_market_id.integer' => 'Invalid market selection.',
            'from_amount.required' => 'Please enter an amount to swap.',
            'from_amount.numeric' => 'Amount must be a valid number.',
            'from_amount.min' => 'Amount must be greater than 0.',
            'from_amount.max' => 'Amount exceeds maximum limit.',
        ];
    }
}
