<?php

namespace App\Http\Requests;

use App\Models\Plan;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $uuid = $this->route('plan')->uuid;
        $plan = Plan::where('uuid', $uuid)->first();

        return [
            'name' => ['required', 'unique:plans,name' . ',' . $plan->id, 'string'],
            'type' => ['required', 'string'],
            'features' => ['required', 'string'],
            'trades_per_day' => ['integer', 'required'],
            'minimum' => ['required'],
            'maximum' => ['required'],
            'daily_profit' => ['integer', 'required'],
            'daily_profit_duration' => ['required'],
        ];
    }
}
