<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTradeBotRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['sometimes', 'string', 'max:255'],
            'minimum' => ['sometimes', 'numeric'],
            'maximum' => ['sometimes', 'numeric'],
            'currency' => ['sometimes', 'string', 'max:255'],
            'asset_pairs' => ['sometimes', 'string'],
            'features' => ['nullable', 'string'],
            'description' => ['nullable', 'string'],
            'parameters' => ['nullable', 'string'],
        ];
    }
}
