<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Enum\TradeBotUserStatus;
use Illuminate\Database\Eloquent\Model;

class TradeBotUser extends Model
{
    protected $guarded = [];

    protected $casts = [
        'status' => TradeBotUserStatus::class,
        'meta' => 'array',
    ];
    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }
}
