<?php

namespace App\Models;

use App\Enum\TraderExperience;
use App\Enum\TraderStatus;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Trader extends Model
{
    protected $guarded = [];

    protected $casts = [
        'status' => TraderStatus::class,
        'experience' => TraderExperience::class,
    ];

    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subscriptions()
    {
        return $this->hasMany(TraderSubscription::class);
    }
}
