<?php

use App\Models\Market;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trades', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Market::class)->constrained()->cascadeOnDelete();

            $table->enum('type', ['buy', 'sell']);
            $table->enum('mode', ['demo', 'live'])->default('demo');
            $table->decimal('amount', 16, 2);
            $table->decimal('entry_price', 16, 8);
            $table->decimal('exit_price', 16, 8)->nullable();

            $table->decimal('profit', 16, 2)->default(0);
            $table->enum('status', ['open', 'closed'])->default('open');

            $table->timestamp('opened_at');
            $table->timestamp('closed_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trades');
    }
};
