<?php

namespace Database\Seeders;

use App\Models\TradeBot;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class TradeBotSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        TradeBot::insert([
            [
                'uuid'        => Str::uuid(),
                'name'        => 'Scalping Bot',
                'minimum'     => 50.00000000,
                'maximum'     => 1000.00000000,
                'currency'    => 'United State Dollar-USD-$',
                'asset_pairs' => 'BTC/USDT,ETH/USDT',
                'features'    => 'Fast execution,Low latency,High-frequency trades',
                'parameters'  => 'timeframe=1m,risk=low,stop_loss=0.5%,take_profit=1%',
                'description' => 'Designed for quick market entries and exits with small profit margins.',
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'uuid'        => Str::uuid(),
                'name'        => 'Swing Trading Bot',
                'minimum'     => 200.00000000,
                'maximum'     => 5000.00000000,
                'currency'    => 'United State Dollar-USD-$',
                'asset_pairs' => 'BTC/USDT,ETH/USDT,BNB/USDT',
                'features'    => 'Trend detection,Multi-day trades,Indicator-based',
                'parameters'  => 'timeframe=4h,risk=medium,stop_loss=2%,take_profit=6%',
                'description' => 'Captures medium-term market movements using technical indicators.',
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'uuid'        => Str::uuid(),
                'name'        => 'AI Smart Bot',
                'minimum'     => 500.00000000,
                'maximum'     => 20000.00000000,
                'currency'    => 'United State Dollar-USD-$',
                'asset_pairs' => 'BTC/USDT,ETH/USDT,SOL/USDT',
                'features'    => 'AI signals,Market sentiment,Adaptive strategy',
                'parameters'  => 'timeframe=15m,risk=adaptive,stop_loss=dynamic,take_profit=dynamic',
                'description' => 'Uses AI-driven signals and market sentiment to adapt trading behavior.',
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
        ]);
    }
}
