<?php

namespace Database\Seeders;

use App\Models\Wallet;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class WalletSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $wallets = [
            [
                'name' => 'Bitcoin Wallet',
                'symbol' => 'BTC',
                'address' => '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                'network' => 'Bitcoin Mainnet',
                'qr_code_path' => null,
                'logo_path' => '/assets/images/wallet/bitcoin.jpg',
                'balance' => 0.0,
                'status' => 'active',
                'description' => 'Primary Bitcoin wallet for deposits and withdrawals.',
            ],
            [
                'name' => 'Ethereum Wallet',
                'symbol' => 'ETH',
                'address' => '0x742d35Cc6634C0532925a3b844Bc454e4438f44e',
                'network' => 'Ethereum Mainnet',
                'qr_code_path' => null,
                'logo_path' => '/assets/images/wallet/ethereum.png',
                'balance' => 0.0,
                'status' => 'active',
                'description' => 'Primary Ethereum wallet.',
            ],
            [
                'name' => 'Tether Wallet',
                'symbol' => 'USDT',
                'address' => '0xdAC17F958D2ee523a2206206994597C13D831ec7',
                'network' => 'ERC20',
                'qr_code_path' => null,
                'logo_path' => '/assets/images/wallet/tether.png',
                'balance' => 0.0,
                'status' => 'active',
                'description' => 'Tether stablecoin wallet.',
            ],
        ];

        foreach ($wallets as $wallet) {
            Wallet::create(array_merge($wallet, [
                'uuid' => Str::uuid(),
            ]));
        }
    }
}
