 <div class="table-responsive">
     <table id="myTable" class="table table-bordered">
         <thead>
             <tr>
                 <th>#</th>
                 <th>Reference ID</th>
                 <th>Amount</th>
                 <th>Method</th>
                 <th>Status</th>
                 <th>Action</th>
             </tr>
         </thead>
         <tbody>
             @foreach ($transactions as $transaction)
                 <tr>
                     <td>{{ $loop->iteration }}</td>
                     <td>{{ $transaction->reference_id }}</td>
                     <td>{{ currency($transaction->user->currency) }}{{ formatAmount($transaction->amount) }}
                     </td>
                     <td>{{ $transaction->deposit_method }}</td>
                     <td>
                         <span class="{{ $transaction->status->badge() }}">
                             {{ $transaction->status->label() }}
                         </span>
                     </td>
                     <td>
                         @if (request()->routeIs('admin.user.deposit.*'))
                             <a href="{{ route('admin.user.deposit.show', [$user->uuid, $transaction->uuid]) }}"
                                 class="btn btn-warning btn-sm m-1"> <i class="ti ti-eye me-1"></i> View</a>

                             <form action="{{ route('admin.user.deposit.delete', [$user->uuid, $transaction->uuid]) }}"
                                 method="POST">
                                 @csrf
                                 @method('DELETE')
                                 <button type="submit" class="btn btn-danger btn-sm m-1"
                                     onclick="return confirm('Are you sure?')">
                                     <i class="ti ti-trash me-1">
                                     </i>Delete
                                 </button>
                             </form>
                         @else
                             <a href="{{ route('user.deposit.show', $transaction->uuid) }}"
                                 class="btn btn-warning btn-sm m-1"> <i class="ti ti-eye me-1"></i> View</a>
                         @endif
                     </td>
                 </tr>
             @endforeach
         </tbody>
     </table>
 </div>
