<div class="table-responsive">
    <table class="table table-bordered align-middle">
        <tbody>
            <tr>
                <th scope="row" class="w-25">Transaction ID</th>
                <td>{{ $transaction->uuid }}</td>
            </tr>
            <tr>
                <th scope="row" class="w-25">Transaction Reference</th>
                <td>{{ $transaction->reference_id }}</td>
            </tr>

            <tr>
                <th>Type</th>
                <td>{{ $transaction->type->label() }}</td>
            </tr>

            <tr>
                <th>Amount</th>
                <td>
                    <strong>
                        @if ($transaction->isDirectionCredit())
                            <span class="text-success">
                                +{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                            </span>
                        @else
                            <span class="text-danger">
                                -{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                            </span>
                        @endif
                    </strong>
                </td>
            </tr>

            <tr>
                <th>Description</th>
                <td>{{ $transaction->description ?? 'N/A' }}</td>
            </tr>

            @if ($transaction->note)
                <tr>
                    <th>Additional Note</th>
                    <td>{{ $transaction->note ?? 'N/A' }}</td>
                </tr>
            @endif

            <tr>
                <th>Status</th>
                <td>
                    <span class="{{ $transaction->status->badge() }}">
                        {{ $transaction->status->label() }}
                    </span>
                </td>
            </tr>

            <tr>
                <th>Transaction Date</th>
                <td>{{ formatDateTime($transaction->transaction_at) }}</td>
            </tr>

        </tbody>
    </table>
</div>
