@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.plan.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">
                    <dt class="col-sm-3">Name:</dt>
                    <dd class="col-sm-9">{{ $plan->name }}</dd>

                    <dt class="col-sm-3">Type:</dt>
                    <dd class="col-sm-9">{{ $plan->type->label() }}</dd>

                    <dt class="col-sm-3">Features:</dt>
                    <dd class="col-sm-9">
                        {{ $plan->features }}
                    </dd>

                    <dt class="col-sm-3">Trades Per Day:</dt>
                    <dd class="col-sm-9">
                        {{ $plan->trades_per_day }}
                    </dd>

                    <dt class="col-sm-3">Minimum:</dt>
                    <dd class="col-sm-9">
                        {{ formatAmount($plan->minimum, 0) }}
                    </dd>

                    <dt class="col-sm-3">Maximum:</dt>
                    <dd class="col-sm-9">
                        {{ formatAmount($plan->maximum, 0) }}
                    </dd>

                    <dt class="col-sm-3">Daily Profit:</dt>
                    <dd class="col-sm-9">
                        {{ $plan->daily_profit }}
                    </dd>

                    <dt class="col-sm-3">Duration:</dt>
                    <dd class="col-sm-9">
                        {{ $plan->daily_profit_duration }}
                    </dd>

                    <dt class="col-sm-3">Created At:</dt>
                    <dd class="col-sm-9">{{ $plan->created_at->diffForHumans() }}</dd>

                    <dt class="col-sm-3">Updated At:</dt>
                    <dd class="col-sm-9">{{ $plan->updated_at->diffForHumans() }}</dd>
                </dl>

                <div class="d-flex gap-2">
                    <a href="{{ route('admin.plan.show', $plan->uuid) }}" class="btn btn-info btn-sm m-1">
                        <i class="fa fa-file-text me-1"></i> View
                    </a>

                    <a href="{{ route('admin.plan.edit', $plan->uuid) }}" class="btn btn-primary btn-sm m-1">
                        <i class="fa fa-edit me-1"></i> Edit
                    </a>

                    <form action="{{ route('admin.plan.delete', $plan->uuid) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm m-1"
                            onclick="return confirm('Are you sure you want to delete this plan?')">
                            <i class="fa fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
