@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}">

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Currency</th>
                                <th>Telegram Username</th>
                                <th>Plan</th>
                                <th>Transaction ID</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($premiumSignalSubscriptions as $premium)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><a
                                            href="{{ route('admin.user.show', $premium->user->uuid) }}">{{ $premium->user->name }}</a>
                                    </td>
                                    <td>{{ currency($premium->user->currency, 'code') }}</td>
                                    <td>{{ $premium->telegram_username }}</td>
                                    <td>
                                        <a href="{{ route('admin.plan.show', $premium->plan->uuid) }}">{{ $premium->plan->name }}
                                            {{ currency($premium->user->currency) }}{{ formatAmount($premium->plan->minimum) }}</a>
                                    </td>
                                    <td>{{ $premium->transaction_id }}
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.premium.signal.subscription.show', $premium->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @foreach ($premiumSignalSubscriptions as $premium)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <strong>Name: </strong>
                                    <a
                                        href="{{ route('admin.user.show', $premium->user->uuid) }}">{{ $premium->user->name }}</a>
                                </h5>

                                <p class="mb-1"><strong>Currency:</strong>
                                    {{ currency($premium->user->currency, 'code') }}
                                </p>
                                <p class="mb-1"><strong>Telegram Username:</strong>
                                    {{ $premium->telegram_username }}
                                </p>
                                <p class="mb-1"><strong>Plan:</strong>
                                    <a href="{{ route('admin.plan.show', $premium->plan->uuid) }}">{{ $premium->plan->name }}
                                        {{ currency($premium->user->currency) }}{{ formatAmount($premium->plan->minimum) }}</a>
                                </p>
                                <p class="mb-2"><strong>Transaction ID:</strong>
                                    {{ $premium->transaction_id }}
                                </p>

                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.premium.signal.subscription.show', $premium->uuid) }}"
                                        class="btn btn-info btn-sm m-1">
                                        <i class="fa fa-file-text me-1"></i> View
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
