@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.premium.signal.subscription.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                @php
                    $premium = $premiumSignalSubscription;
                @endphp

                <dl class="row">
                    <dt class="col-sm-3">Name:</dt>
                    <dd class="col-sm-9">
                        <a href="{{ route('admin.user.show', $premium->user->uuid) }}">{{ $premium->user->name }}</a>
                    </dd>

                    <dt class="col-sm-3">Currency:</dt>
                    <dd class="col-sm-9">{{ currency($premium->user->currency, 'code') }}</dd>

                    <dt class="col-sm-3">Telegram Username:</dt>
                    <dd class="col-sm-9">
                        {{ $premium->telegram_username }}
                    </dd>

                    <dt class="col-sm-3">Plan:</dt>
                    <dd class="col-sm-9">
                        <a href="{{ route('admin.plan.show', $premium->plan->uuid) }}">{{ $premium->plan->name }}
                            {{ currency($premium->user->currency) }}{{ formatAmount($premium->plan->minimum) }}</a>
                    </dd>

                    <dt class="col-sm-3">Transaction ID:</dt>
                    <dd class="col-sm-9">
                        {{ $premium->transaction_id }}
                    </dd>

                    @if ($premium->proof)
                        <dt class="col-sm-3">Payment Proof:</dt>
                        <dd class="col-sm-9">
                            <a href="{{ asset($premium->proof) }}" target="_blank"><img src="{{ asset($premium->proof) }}"
                                    width="200" class="img-thumbnail"></a>
                        </dd>
                    @endif
                </dl>
            </x-dashboard.card>

        </div>

    </div>
@endsection
