@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.signal.create'),
                'text' => 'Add New Signal',
                'icon' => 'fa fa-plus me-1',
            ]">

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Asset</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Action</th>
                                <th>Unit</th>
                                <th>Interval (In Minutes)</th>
                                <th>Created</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($signals as $signal)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        {{ $signal->market->asset }}
                                    </td>
                                    <td>{{ $signal->type->label() }}</td>
                                    <td>{{ formatAmount($signal->amount, 0) }}</td>
                                    <td>{{ $signal->action->label() }}</td>
                                    <td>{{ $signal->unit }}</td>
                                    <td>{{ $signal->duration->label() }}</td>
                                    <td>{{ $signal->created_at->diffForHumans() }}</td>
                                    <td>
                                        <a href="{{ route('admin.signal.show', $signal->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>

                                        <a href="{{ route('admin.signal.edit', $signal->uuid) }}"
                                            class="btn btn-primary btn-sm m-1">
                                            <i class="fa fa-edit me-1"></i> Edit
                                        </a>

                                        <form action="{{ route('admin.signal.delete', $signal->uuid) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this signal?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @foreach ($signals as $signal)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <strong> Asset:</strong>
                                    {{ $signal->market->asset }}
                                </h5>

                                <p class="mb-1"><strong>Type:</strong>
                                    {{ $signal->type->label() }}
                                </p>
                                <p class="mb-1"><strong>Amount:</strong>
                                    {{ formatAmount($signal->amount, 0) }}
                                </p>
                                <p class="mb-1"><strong>Action:</strong>
                                    {{ $signal->action->label() }}
                                </p>
                                <p class="mb-1"><strong>Unit:</strong>
                                    {{ $signal->unit }}
                                </p>
                                <p class="mb-1"><strong>Interval (In Minutes):</strong>
                                    {{ $signal->duration->label() }}
                                </p>
                                <p class="mb-2"><strong>Created:</strong>
                                    {{ $signal->created_at->diffForHumans() }}
                                </p>

                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.signal.show', $signal->uuid) }}"
                                        class="btn btn-info btn-sm m-1">
                                        <i class="fa fa-file-text me-1"></i> View
                                    </a>

                                    <a href="{{ route('admin.signal.edit', $signal->uuid) }}"
                                        class="btn btn-primary btn-sm m-1">
                                        <i class="fa fa-edit me-1"></i> Edit
                                    </a>

                                    <form action="{{ route('admin.signal.delete', $signal->uuid) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm m-1"
                                            onclick="return confirm('Are you sure you want to delete this signal?')">
                                            <i class="fa fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
