@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trade.bot.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.trade.bot.update', $tradeBot->uuid) }}" method="post">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <x-dashboard.form-input name="name" label="Name" class="col-md-12 mb-3"
                            value="{{ old('name', $tradeBot->name) }}" required />

                        <x-dashboard.form-input name="minimum" label="Minimum" class="col-md-6 mb-3"
                            value="{{ old('minimum', $tradeBot->minimum) }}" type="number" required />

                        <x-dashboard.form-input name="maximum" label="Maximum" class="col-md-6 mb-3"
                            value="{{ old('maximum', $tradeBot->maximum) }}" type="number" required />

                        <!-- Currencies -->
                        <div class="col-md-6 mb-3">
                            <label for="currency" class="form-label fw-semibold">Currencies</label>
                            <select name="currency" id="currency"
                                class="form-select @error('currency') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($currencies as $currency)
                                    <option value="{{ $currency->value }}"
                                        {{ old('currency', $tradeBot->currency->value) == $currency->value ? 'selected' : '' }}>
                                        {{ $currency->name() }}</option>
                                @endforeach
                            </select>
                            @error('currency')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <x-dashboard.form-input name="asset_pairs" label="Market/Asset Pairs" class="col-md-6 mb-3"
                            value="{{ old('asset_pairs', $tradeBot->asset_pairs) }}" placeholder="BTC/USDT" required />

                        <x-dashboard.form-input name="description" label="Description" class="col-md-6 mb-3"
                            value="{{ old('description', $tradeBot->description) }}" type="textarea" />

                        <x-dashboard.form-input name="features" label="Features" class="col-md-6 mb-3"
                            value="{{ old('features', $tradeBot->features) }}" type="textarea" />

                        <x-dashboard.form-input name="parameters" label="Parameters" class="col-md-12 mb-3"
                            value="{{ old('parameters', $tradeBot->parameters) }}"
                            placeholder="Market Asset/Pairs: BTC/USD, Parameter2: value2, Parameter3: value3"
                            type="textarea" />
                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
