@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trader.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.trader.store') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="user_id" class="form-label fw-semibold">Select User</label>
                            <select name="user_id" id="user_id"
                                class="form-select @error('user_id') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($users as $user)
                                    <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                        {{ $user->name }}</option>
                                @endforeach
                            </select>
                            @error('user_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <x-dashboard.form-input name="image" label="Image" class="col-md-12 mb-3" type="file" />

                        <x-dashboard.form-input name="balance" label="Balance" class="col-md-12 mb-3" type="number"
                            value="{{ old('balance') }}" required />

                        <div class="col-md-12 mb-3">
                            <label for="trader_status" class="form-label fw-semibold">Select Status</label>
                            <select name="status" id="trader_status"
                                class="form-select @error('status') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($traderStatus as $status)
                                    <option value="{{ $status->value }}"
                                        {{ old('status') == $status->value ? 'selected' : '' }}>
                                        {{ $status->label() }}</option>
                                @endforeach
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mb-3">
                            <label for="trader_experience" class="form-label fw-semibold">Select Experience</label>
                            <select name="experience" id="trader_experience"
                                class="form-select @error('experience') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($traderExperience as $experience)
                                    <option value="{{ $experience->value }}"
                                        {{ old('experience') == $experience->value ? 'selected' : '' }}>
                                        {{ $experience->label() }}</option>
                                @endforeach
                            </select>
                            @error('experience')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <x-dashboard.form-input name="notes" label="Notes" class="col-md-12 mb-3" value="{{ old('notes') }}" type="textarea" />
                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
