@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('admin.user.notification.index', $user->uuid),
                    'text' => 'Back',
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <dl class="row">
                        <dt class="col-sm-3">Title:</dt>
                        <dd class="col-sm-9">{{ $notification->title }}</dd>

                        <dt class="col-sm-3">Message:</dt>
                        <dd class="col-sm-9">{{ $notification->description }}</dd>

                        <dt class="col-sm-3">Status:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $notification->read->badge() }}">
                                {{ $notification->read->label() }}
                            </span>
                        </dd>

                        <dt class="col-sm-3">Created At:</dt>
                        <dd class="col-sm-9">{{ $notification->created_at->diffForHumans() }}</dd>
                    </dl>

                </x-dashboard.card>
            </div>
        </div>

    </div>
@endsection
