@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}" :button="[
                    'text' => 'Back to Profile',
                    'route' => route('admin.user.show', $user->uuid),
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <form action="{{ route('admin.user.status', $user->uuid) }}" method="post">
                        @csrf
                        @method('PATCH')

                        <div class="mb-3">
                            <label for="example-select" class="form-label">Status</label>
                            <select name="status" id="example-select" class="form-select">
                                @foreach ($userStatues as $status)
                                    <option value="{{ $status->value }}" @selected($status->value === $user->status->value)>
                                        {{ $status->label() }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <x-dashboard.form-button />
                    </form>

                </x-dashboard.card>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
