@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}">

                    <div class="table-responsive d-none d-md-block">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Market Asset</th>
                                    <th>Type</th>
                                    <th>Mode</th>
                                    <th>Amount</th>
                                    <th>Entry Price</th>
                                    <th>Exit Price</th>
                                    <th>Profit</th>
                                    <th>Status</th>
                                    <th>Opened At</th>
                                    <th>Closed At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($trades as $trade)
                                    <tr>
                                        <td>{{ $trade->market->asset }}</td>
                                        <td>{{ $trade->type->label() }}</td>
                                        <td>{{ $trade->mode->label() }}</td>
                                        <td>{{ formatAmount($trade->amount) }}</td>
                                        <td>{{ formatAmount($trade->entry_price) }}</td>
                                        <td>{{ formatAmount($trade->exit_price) }}</td>
                                        <td>{{ formatAmount($trade->profit) }}</td>
                                        <td>
                                            <span
                                                class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                                        </td>
                                        <td>
                                            @if ($trade->opened_at)
                                                {{ $trade->opened_at->diffForHumans() }}
                                            @endif
                                        </td>
                                        <td>
                                            @if ($trade->closed_at)
                                                {{ $trade->closed_at->diffForHumans() }}
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.user.trade.show', [$user->uuid, $trade->uuid]) }}"
                                                class="btn btn-info btn-sm m-1"> <i class="fa fa-file-text me-1"></i>
                                                View</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-block d-md-none">
                        @foreach ($trades as $trade)
                            <div class="card mb-3 shadow-sm">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <strong> Market Asset:</strong>
                                        {{ $trade->market->asset }}
                                    </h5>

                                    <p class="mb-1"><strong>Type:</strong>
                                        {{ $trade->type->label() }}
                                    </p>
                                    <p class="mb-1"><strong>Mode:</strong>
                                        {{ $trade->mode->label() }}
                                    </p>
                                    <p class="mb-1"><strong>Amount:</strong>
                                        {{ formatAmount($trade->amount) }}
                                    </p>
                                    <p class="mb-1"><strong>Entry Price:</strong>
                                        {{ formatAmount($trade->entry_price) }}
                                    </p>
                                    <p class="mb-1"><strong>Exit Price:</strong>
                                        {{ formatAmount($trade->exit_price) }}
                                    </p>
                                    <p class="mb-1"><strong>Profit:</strong>
                                        {{ formatAmount($trade->profit) }}
                                    </p>
                                    <p class="mb-1"><strong>Status:</strong>
                                        <span class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                                    </p>
                                    <p class="mb-1"><strong>Opened At:</strong>
                                        @if ($trade->opened_at)
                                            {{ $trade->opened_at->diffForHumans() }}
                                        @endif
                                    </p>
                                    <p class="mb-2"><strong>CLosed At:</strong>
                                        @if ($trade->closed_at)
                                            {{ $trade->closed_at->diffForHumans() }}
                                        @endif
                                    </p>

                                    <div class="d-flex gap-2">
                                        <a href="{{ route('admin.user.trade.show', [$user->uuid, $trade->uuid]) }}"
                                            class="btn btn-info btn-sm m-1"> <i class="fa fa-file-text me-1"></i>
                                            View</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                </x-dashboard.card>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
