@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.wallet.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.wallet.store') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="row">
                        <x-dashboard.form-input name="name" value="{{ old('name') }}" label="Name"
                            placeholder="Bitcoin Wallet" type="text" class="col-md-6 mb-3" />

                        <x-dashboard.form-input name="symbol" value="{{ old('symbol') }}" label="Symbol" type="text"
                            placeholder="BTC" class="col-md-6 mb-3" />

                        <x-dashboard.form-input name="address" value="{{ old('address') }}" label="Address" type="text"
                            placeholder="Public blockchain address" class="col-md-6 mb-3" />

                        <x-dashboard.form-input name="network" value="{{ old('network') }}" label="Network" type="text"
                            placeholder="e.g., Bitcoin Mainnet, ERC20" class="col-md-6 mb-3" />

                        <x-dashboard.form-input name="qr_code_path" label="QR Code" type="file" class="col-md-6 mb-3" />

                        <x-dashboard.form-input name="logo_path" label="Logo" type="file" class="col-md-6 mb-3" />

                        <x-dashboard.form-input name="balance" value="{{ old('balance') }}" label="Balance" type="number"
                            type="text" placeholder="0.00000000" class="col-md-6 mb-3" />

                        <div class="col-md-6 mb-3">
                            <label for="example-select" class="form-label">Status</label>
                            <select name="status" id="example-select"
                                class="form-select  @error('status') is-invalid @enderror">
                                <option value="">Select Status</option>
                                @foreach ($walletStatues as $status)
                                    <option value="{{ $status->value }}"
                                        {{ old('status') == $status->value ? 'selected' : '' }}>
                                        {{ $status->label() }}
                                    </option>
                                @endforeach
                            </select>

                            <x-dashboard.input-error name="status" />
                        </div>

                        <x-dashboard.form-input name="description" value="{{ old('description') }}" type="textarea"
                            label="Description" class="col-md-12 mb-3" />
                    </div>

                    <x-dashboard.form-button />
                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
