@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.wallet.create'),
                'text' => 'Add New Wallet',
                'icon' => 'fa fa-plus me-1',
            ]">

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Symbol</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($wallets as $wallet)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $wallet->name }}</td>
                                    <td>{{ $wallet->symbol }}</td>
                                    <td>
                                        <span class="{{ $wallet->status->badge() }}">
                                            {{ $wallet->status->label() }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.wallet.show', $wallet->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>

                                        <a href="{{ route('admin.wallet.edit', $wallet->uuid) }}"
                                            class="btn btn-primary btn-sm m-1">
                                            <i class="fa fa-edit me-1"></i> Edit
                                        </a>

                                        <form action="{{ route('admin.wallet.delete', $wallet->uuid) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this wallet?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @foreach ($wallets as $wallet)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title"><strong>Name:</strong>
                                    {{ $wallet->name }}
                                </h5>

                                <p class="mb-1"><strong>Symbol:</strong> {{ $wallet->symbol }}</p>
                                <p class="mb-2"><strong>Status:</strong>
                                    <span class="{{ $wallet->status->badge() }}">
                                        {{ $wallet->status->label() }}
                                    </span>
                                </p>

                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.wallet.show', $wallet->uuid) }}"
                                        class="btn btn-info btn-sm m-1">
                                        <i class="fa fa-file-text me-1"></i> View
                                    </a>

                                    <a href="{{ route('admin.wallet.edit', $wallet->uuid) }}"
                                        class="btn btn-primary btn-sm m-1">
                                        <i class="fa fa-edit me-1"></i> Edit
                                    </a>

                                    <form action="{{ route('admin.wallet.delete', $wallet->uuid) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm m-1"
                                            onclick="return confirm('Are you sure you want to delete this wallet?')">
                                            <i class="fa fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
