@extends('dashboard.master.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <x-dashboard.card title="Edit Admin" :button="[
                    'text' => 'Back',
                    'route' => route('master.admin.index'),
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <form action="{{ route('master.admin.update', $user->uuid) }}" method="post">
                        @csrf
                        @method('PATCH')

                        <div class="row">
                            <x-dashboard.form-input name="name" label="Name" value="{{ $user->name }}" />

                            <x-dashboard.form-input name="email" label="Email" value="{{ $user->email }}" />

                            <x-dashboard.form-input name="password" id="new_password" label="Password" type="password" />

                            <div class="col-md-6 mb-3">
                                <label for="example-select" class="form-label">Status</label>
                                <select id="example-select" name="status"
                                    class="form-select @error('status') is-invalid @enderror">
                                    <option value="">Select Status</option>
                                    @foreach ($userStatuses as $status)
                                        <option value="{{ $status->value }}" @selected(old('status', $user->status->value) == $status->value)>
                                            {{ $status->label() }}
                                        </option>
                                    @endforeach
                                </select>
                                <x-dashboard.input-error name="status" />
                            </div>
                        </div>

                        <x-dashboard.form-button />
                    </form>

                </x-dashboard.card>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
