@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row justify-content-center mt-3 mb-3">

            <div class="col-lg-8">

                <div class="card shadow-sm">
                    <div class="card-body p-4">

                        <!-- Header -->
                        <div class="text-center mb-4">
                            <i class="ti ti-check-shield fs-1 text-success"></i>
                            <h4 class="fw-semibold mt-2">Payment Confirmation</h4>
                            <p class="text-muted mb-0">
                                Submit your transaction details below for verification.
                            </p>
                        </div>

                        <!-- Info Alert -->
                        <div class="alert alert-info d-flex align-items-start">
                            <i class="ti ti-info-circle fs-4 me-2"></i>
                            <div>
                                Payments are verified manually.
                                Please ensure all details provided are accurate to avoid delays.
                            </div>
                        </div>

                        <!-- Form -->
                        <form action="{{ route('user.plan.payment.proof.store', [$plan->uuid, $wallet->uuid]) }}"
                            method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="row g-3">

                                <!-- Wallet / Asset -->
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Payment Method</label>
                                    <input type="text" class="form-control" value="{{ $wallet->name }}" readonly>
                                </div>

                                <!-- Amount -->
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Amount Sent</label>
                                    <input type="number" step="any" name="amount" class="form-control"
                                        placeholder="Enter amount sent" required>
                                </div>

                                <!-- Transaction Hash -->
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Transaction Hash / ID</label>
                                    <input type="text" name="transaction_hash" class="form-control"
                                        placeholder="Paste your transaction hash" required>
                                </div>

                                <!-- Upload Proof -->
                                <div class="col-12">
                                    <label class="form-label fw-semibold">
                                        Upload Proof (Screenshot or Receipt)
                                    </label>
                                    <input type="file" name="proof" class="form-control"
                                        accept="image/*,application/pdf" required>
                                    <small class="text-muted">
                                        Accepted formats: JPG, PNG, PDF
                                    </small>
                                </div>

                                <!-- Notes -->
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Additional Notes (Optional)</label>
                                    <textarea name="note" class="form-control" rows="3" placeholder="Any additional information"></textarea>
                                </div>

                            </div>

                            <hr class="my-4">

                            <!-- Submit -->
                            <div class="d-flex justify-content-between align-items-center">
                                <a href="{{ url()->previous() }}" class="btn btn-light">
                                    <i class="ti ti-arrow-back"></i> Back
                                </a>

                                <button type="submit" class="btn btn-success px-4">
                                    <i class="ti ti-send"></i> Submit for Verification
                                </button>
                            </div>

                        </form>

                    </div>
                </div>

                <!-- Footer Note -->
                <p class="text-center text-muted mt-3">
                    Verification typically takes a few minutes to a few hours depending on network activity.
                </p>

            </div>
        </div>

    </div>
@endsection
