@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <x-dashboard.card title="Email-Based Two-Factor Authentication"
                    subtitle="Add an extra layer of security to your account" :button="[
                        'route' => route('user.profile.index'),
                        'text' => 'Back to Profile',
                        'icon' => 'fa fa-arrow-left me-1',
                    ]">
                    {{-- <div class="card-header border-bottom">
                        Email-Based Two-Factor Authentication <br>
                        <small>Add an extra layer of security to your account</small>
                    </div> --}}
                    {{-- <div class="card-body"> --}}
                    <span class="{{ $user->two_factor_enabled->badge() }}">
                        <i class="fa fa-shield"></i> {{ $user->two_factor_enabled->label() }}
                    </span> <b>Current Status</b>

                    <p>
                        When enabled, a 6-digit verification code will be sent to your email address <a
                            href="{{ route('user.profile.index') }}"
                            class="text-primary font-weight-bolder">{{ $user->email }}</a>
                        each time you log in to your account.
                    </p>

                    <x-dashboard.info-list title="How Two-Factor Authentication Works" icon="fa-solid fa-info"
                        :options="[
                            'When you log in with your password, a 6-digit code will be sent to your email',
                            'You must enter this code to complete your login',
                            'This adds an extra layer of security to your account',
                            'The code expires after 10 minutes for security',
                        ]" />

                    @if (!$user->twoFactorEnabled())
                        <form action="{{ route('user.profile.2fa.enable') }}" method="post">
                            @csrf
                            <x-dashboard.form-button icon="fa-solid fa-shield me-1" name="Enable Two-Factor Authentication"
                                class="btn btn-success" />
                        </form>
                    @else
                        <form action="{{ route('user.profile.2fa.disable') }}" method="post">
                            @csrf
                            <x-dashboard.form-button icon="fa-solid fa-shield me-1" name="Disable Two-Factor Authentication"
                                class="btn btn-danger" />
                        </form>
                    @endif
                    {{-- </div> --}}
                </x-dashboard.card>
            </div>
            <div class="col-md-4">
                <x-dashboard.card icon="fa-solid fa-lightbulb me-1" title="Security Tips">
                    <x-dashboard.tips :options="[
                        'Use a strong, unique password',
                        'Enable two-factor authentication',
                        'Keep your email secure',
                        'Log out when using shared devices',
                        'Regularly check your account activity',
                    ]" />
                </x-dashboard.card>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
