@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <x-dashboard.card title="KYC Verification" :button="[
                    'route' => route('user.profile.index'),
                    'text' => 'Back to Profile',
                    'icon' => 'fa fa-arrow-left me-1',
                ]">
                    @if ($user->kycPendingAndHasDocument())
                        <div class="alert alert-warning mb-0">
                            <i class="fa fa-clock me-1"></i>
                            Your verification is currently under review. Please wait for approval.
                        </div>
                    @elseif($user->kycApproved())
                        <div class="alert alert-success mb-3">
                            <i class="fa fa-check-circle me-1"></i>
                            Your identity has been successfully verified. Thank you!
                        </div>
                    @elseif($user->kycRejected())
                        <div class="alert alert-danger">
                            <i class="fa fa-times-circle me-1"></i>
                            Your KYC submission was rejected. Please review your details and try again.
                        </div>

                        @include('dashboard.user.partials.kyc_form')
                    @else
                        @include('dashboard.user.partials.kyc_form')
                    @endif
                </x-dashboard.card>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
