@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">

                <x-dashboard.card title="{{ $title }}">

                    @include('dashboard.user.partials.trade')

                </x-dashboard.card>

            </div>

            <div class="col-md-6 card">

                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                    <div class="tradingview-widget-container__widget"></div>
                    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow"
                            target="_blank"><span class="blue-text">Track all markets on
                                TradingView</span></a></div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-technical-analysis.js"
                        async>
                        {
                            "interval": "1m",
                            "width": "100%",
                            "isTransparent": true,
                            "height": "100%",
                            "symbol": "BITSTAMP:BTCUSD",
                            "showIntervalTabs": true,
                            "locale": "en",
                            "colorTheme": "dark"
                        }
                    </script>
                </div>
                <!-- TradingView Widget END -->

            </div>
        </div>

        <!-- Active Trades -->
        <div class="row mt-4">
            <div class="col-12">
                <x-dashboard.card title="Open Trades">

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Market Asset</th>
                                    <th>Type</th>
                                    <th>Mode</th>
                                    <th>Amount</th>
                                    <th>Entry Price</th>
                                    <th>Exit Price</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($openTrades as $trade)
                                    <tr>
                                        <td>{{ $trade->market->asset }}</td>
                                        <td>{{ $trade->type->label() }}</td>
                                        <td>{{ $trade->mode->label() }}</td>
                                        <td>{{ formatAmount($trade->amount) }}</td>
                                        <td>{{ formatAmount($trade->entry_price) }}</td>
                                        <td>{{ formatAmount($trade->exit_price) }}</td>
                                        <td>
                                            <span class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                                        </td>
                                        <td>
                                            <a href="{{ route('user.trade.close', $trade->uuid) }}"
                                                class="btn btn-sm btn-danger"> <i class="fa fa-times me-1"></i> Close</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </x-dashboard.card>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <x-dashboard.card title="Trade History">

                    <div class="table-responsive">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Market Asset</th>
                                    <th>Type</th>
                                    <th>Mode</th>
                                    <th>Amount</th>
                                    <th>Entry Price</th>
                                    <th>Exit Price</th>
                                    <th>Status</th>
                                    <th>Closed At</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($closedTrades as $trade)
                                    <tr>
                                        <td>{{ $trade->market->asset }}</td>
                                        <td>{{ $trade->type->label() }}</td>
                                        <td>{{ $trade->mode->label() }}</td>
                                        <td>{{ formatAmount($trade->amount) }}</td>
                                        <td>{{ formatAmount($trade->entry_price) }}</td>
                                        <td>{{ formatAmount($trade->exit_price) }}</td>
                                        <td>
                                            <span
                                                class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                                        </td>
                                        <td>
                                            @if ($trade->closed_at)
                                                {{ $trade->closed_at->diffForHumans() }}
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </x-dashboard.card>
            </div>
        </div>

    </div>
@endsection
