@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row mt-4">

            {{-- Header --}}
            <div class="col-12 mb-4">
                <h4 class="fw-semibold">AI Trade Bots</h4>
                <p class="text-muted mb-0">
                    Automate your trading strategy using intelligent bots designed to analyze markets,
                    manage risk, and execute trades with precision.
                </p>
            </div>

            @forelse ($tradeBots as $tradeBot)
                @php
                    $tradeBotUser = \App\Models\TradeBotUser::where('user_id', $user->id)->where(
                        'trade_bot_id',
                        $tradeBot->id,
                    );

                    $tradeBotUserIsRunning =
                        $tradeBotUser->exists() && $tradeBotUser->first()->status->value == 'running';

                @endphp
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card shadow-sm h-100 border-0">
                        <div class="card-body d-flex flex-column">

                            {{-- Card Header --}}
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h5 class="mb-0">
                                    <i class="ti ti-robot text-primary"></i> {{ $tradeBot->name }}
                                </h5>

                                @if ($tradeBotUser->exists())
                                    <span class="{{ $tradeBotUser->first()->status->badge() }}">
                                        {{ $tradeBotUser->first()->status->label() }}
                                    </span>
                                @else
                                    <span class="badge bg-warning-subtle text-warning fs-12 p-1">
                                        Subscription Required
                                    </span>
                                @endif
                            </div>

                            @if ($tradeBot->description)
                                {{-- Description --}}
                                <p class="text-muted small mb-3">
                                    {{ $tradeBot->description }}
                                </p>
                            @endif

                            @if ($tradeBot->features)
                                {{-- Features --}}
                                @php
                                    $features = is_array($tradeBot->features)
                                        ? $tradeBot->features
                                        : explode(',', $tradeBot->features);
                                @endphp

                                <ul class="small ps-3 mb-4">
                                    @foreach ($features as $feature)
                                        <li>{{ trim($feature) }}</li>
                                    @endforeach
                                </ul>
                            @endif

                            {{-- Action --}}
                            <div class="mt-auto">
                                <button class="btn btn-primary w-100" data-bs-toggle="offcanvas"
                                    data-bs-target="#botOffcanvas{{ $tradeBot->id }}">
                                    Configure & Start
                                    <i class="ti ti-arrow-right"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Offcanvas --}}
                <div class="offcanvas offcanvas-end" tabindex="-1" id="botOffcanvas{{ $tradeBot->id }}">
                    <div class="offcanvas-header border-bottom">
                        <h5 class="mb-0">
                            <i class="ti ti-robot"></i> {{ $tradeBot->name }}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
                    </div>

                    <div class="offcanvas-body">

                        {{-- Bot Parameters --}}
                        <div class="mb-4">
                            <h6 class="fw-semibold mb-3">
                                <i class="ti ti-settings"></i> Bot Parameters
                            </h6>

                            <p><strong>Currency:</strong> {{ $tradeBot->currency->code() }}</p>

                            @php
                                $parameters = is_array($tradeBot->parameters)
                                    ? $tradeBot->parameters
                                    : explode(',', $tradeBot->parameters);
                            @endphp

                            @foreach ($parameters as $param)
                                @if (str_contains($param, ':'))
                                    @php [$key, $value] = explode(':', $param); @endphp
                                    <p class="mb-1">
                                        <strong>{{ trim($key) }}:</strong> {{ trim($value) }}
                                    </p>
                                @endif
                            @endforeach
                        </div>

                        <hr>

                        {{-- Investment Form --}}
                        <div>
                            <h6 class="fw-semibold mb-3">
                                <i class="ti ti-chart-line"></i> Investment Setup
                            </h6>

                            <form method="POST" action="{{ route('user.trade.bot.store') }}">
                                @csrf

                                <input type="hidden" name="trade_bot_id" value="{{ $tradeBot->id }}">
                                <input type="hidden" name="user_id" value="{{ auth()->id() }}">

                                {{-- Wallet & Amount --}}
                                <div class="mb-3">
                                    <label class="form-label text-muted">Wallet & Amount</label>
                                    <div class="input-group">
                                        <select class="form-select @error('wallet_id') is-invalid @enderror"
                                            name="wallet_id">
                                            {{-- Wallet options --}}
                                            @foreach ($wallets as $wallet)
                                                <option value="{{ $wallet->id }}">
                                                    {{ $wallet->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control @error('amount') is-invalid @enderror"
                                            name="amount" placeholder="Enter amount">
                                    </div>
                                    <small class="text-muted">
                                        Need more funds?
                                        <a href="{{ route('user.deposit.method') }}">Deposit</a> |
                                        <a href="#">Transfer</a> |
                                        <a href="#">Convert</a>
                                    </small>
                                </div>

                                {{-- Leverage --}}
                                <div class="mb-3">
                                    <label class="form-label text-muted">Leverage</label>
                                    <input type="range" class="form-range @error('leverage') is-invalid @enderror"
                                        min="20" max="100" step="20" name="leverage">
                                    <div class="d-flex justify-content-between small text-muted">
                                        <span>20x</span>
                                        <span>40x</span>
                                        <span>60x</span>
                                        <span>80x</span>
                                        <span>100x</span>
                                    </div>
                                </div>

                                {{-- Errors --}}
                                @error('trade_bot_id')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                                @error('wallet_id')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                                @error('amount')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                                @error('leverage')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror

                                {{-- Submit --}}
                                @if ($tradeBotUserIsRunning)
                                    <button type="submit" class="btn btn-success w-100 mt-3" disabled>
                                        Trade Bot Running
                                    </button>
                                @else
                                    <button type="submit" class="btn btn-success w-100 mt-3">
                                        Start Trading Bot
                                    </button>
                                @endif
                            </form>
                        </div>

                    </div>
                </div>

            @empty
                <div class="col-12">
                    <div class="alert alert-info text-center py-5">
                        <h5 class="fw-semibold">No Active Bots</h5>
                        <p class="mb-0">
                            There are currently no trade bots available.
                            We’ll notify you once new bots are launched.
                        </p>
                    </div>
                </div>
            @endforelse
        </div>

    </div>
@endsection
