{{-- <!DOCTYPE html>
<html>

    <head>
        <meta charset="UTF-8">
        <title>{{ $newsletter->subject }}</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
    </head>

    <body style="margin:0; padding:0; background-color:#f4f6f8; font-family: Arial, Helvetica, sans-serif;">

        <table width="100%" cellpadding="0" cellspacing="0" style="background-color:#f4f6f8; padding:20px 0;">
            <tr>
                <td align="center">

                    <!-- CONTAINER -->
                    <table width="600" cellpadding="0" cellspacing="0"
                        style="background-color:#ffffff; border-radius:6px; overflow:hidden;">

                        <!-- HEADER -->
                        <tr>
                            <td style="background-color:#0d6efd; padding:20px; text-align:center;">
                                <h1 style="color:#ffffff; margin:0; font-size:22px;">
                                    {{ config('app.name') }}
                                </h1>
                            </td>
                        </tr>

                        <!-- BODY -->
                        <tr>
                            <td style="padding:30px; color:#333333; font-size:14px; line-height:1.7;">

                                <!-- SUBJECT -->
                                <h2 style="margin-top:0; font-size:20px; color:#111111;">
                                    {{ $newsletter->subject }}
                                </h2>

                                <!-- CONTENT -->
                                {!! $newsletter->content !!}

                            </td>
                        </tr>

                        <!-- CTA (OPTIONAL) -->
                        <tr>
                            <td align="center" style="padding:20px;">
                                <a href="{{ config('app.url') }}"
                                    style="background-color:#0d6efd; color:#ffffff; text-decoration:none;
                                  padding:12px 25px; border-radius:4px; display:inline-block;
                                  font-size:14px;">
                                    Visit Our Website
                                </a>
                            </td>
                        </tr>

                        <!-- FOOTER -->
                        <tr>
                            <td
                                style="background-color:#f1f1f1; padding:20px; text-align:center; font-size:12px; color:#777777;">

                                <p style="margin:0;">
                                    You are receiving this email because you subscribed to our newsletter.
                                </p>

                                <p style="margin:10px 0 0;">
                                    © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
                                </p>

                                <p style="margin:10px 0 0;">
                                    <a href="#" style="color:#0d6efd; text-decoration:none;">
                                        Unsubscribe
                                    </a>
                                </p>

                            </td>
                        </tr>

                    </table>

                    <!-- END CONTAINER -->

                </td>
            </tr>
        </table>

    </body>

</html> --}}

<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <title>{{ $newsletter->subject }}</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
    </head>

    <body style="margin:0; padding:0; background:#f4f6f8; font-family:Arial, Helvetica, sans-serif;">

        <div style="max-width:600px; margin:30px auto; background:#ffffff; border-radius:8px; overflow:hidden;">

            <!-- HEADER -->
            <div style="background:#0d6efd; padding:20px; text-align:center;">
                <h1 style="margin:0; font-size:22px; color:#ffffff;">
                    {{ config('app.name') }}
                </h1>
            </div>

            <!-- CONTENT -->
            <div style="padding:30px; color:#333333; font-size:14px; line-height:1.7;">

                <h2 style="margin-top:0; font-size:20px; color:#111111;">
                    {{ $newsletter->subject }}
                </h2>

                <!-- Newsletter Body -->
                {!! $newsletter->content !!}

            </div>

            <!-- CTA -->
            <div style="padding:0 30px 30px; text-align:center;">
                <a href="{{ config('app.url') }}"
                    style="display:inline-block; background:#0d6efd; color:#ffffff;
                  text-decoration:none; padding:12px 28px; border-radius:5px;
                  font-size:14px;">
                    Visit Our Website
                </a>
            </div>

            <!-- FOOTER -->
            <div style="background:#f1f1f1; padding:20px; text-align:center; font-size:12px; color:#777777;">
                <p style="margin:0;">
                    You are receiving this email because you subscribed to our newsletter.
                </p>

                <p style="margin:8px 0 0;">
                    © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
                </p>

                <p style="margin:8px 0 0;">
                    <a href="{{ route('unsubscribe', ['email' => $email]) }}"
                        style="color:#0d6efd; text-decoration:none;">
                        Unsubscribe
                    </a>
                </p>
            </div>

        </div>

    </body>

</html>
