<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Frontend\PageController;
use App\Http\Controllers\Frontend\NewsletterSubscriberController;

Route::get('/', HomeController::class)->name('home');

Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/terms', [PageController::class, 'terms'])->name('terms');
Route::get('/policy', [PageController::class, 'policy'])->name('policy');
Route::get('/forex', [PageController::class, 'forex'])->name('forex');
Route::get('/crypto', [PageController::class, 'crypto'])->name('crypto');
Route::get('/stocks', [PageController::class, 'stocks'])->name('stocks');
Route::get('/etfs', [PageController::class, 'etfs'])->name('etfs');
Route::get('/affiliate', [PageController::class, 'affiliate'])->name('affiliate');

Route::get('/unsubscribe', [NewsletterSubscriberController::class, 'unsubscribe'])->name('unsubscribe');

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/user.php';
require_once __DIR__ . '/admin.php';
require_once __DIR__ . '/master.php';
