<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <!-- Market Ticker -->
            <div class="col-12 mt-3 mb-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-2">
                        <div class="tradingview-widget-container">
                            <div class="tradingview-widget-container__widget"></div>
                            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                                {
                                    "symbols": [{
                                            "proName": "FOREXCOM:SPXUSD",
                                            "title": "S&P 500"
                                        },
                                        {
                                            "proName": "FOREXCOM:NSXUSD",
                                            "title": "US 100"
                                        },
                                        {
                                            "proName": "FX_IDC:EURUSD",
                                            "title": "EUR/USD"
                                        },
                                        {
                                            "proName": "BITSTAMP:BTCUSD",
                                            "title": "Bitcoin"
                                        },
                                        {
                                            "proName": "BITSTAMP:ETHUSD",
                                            "title": "Ethereum"
                                        }
                                    ],
                                    "showSymbolLogo": true,
                                    "colorTheme": "dark",
                                    "displayMode": "adaptive",
                                    "locale": "en"
                                }
                            </script>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Deposit Card -->
            <div class="col-12 grid-margin stretch-card">
                <div class="card shadow-sm">
                    <div class="card-body">

                        <!-- Alert -->
                        <div class="alert alert-success d-flex align-items-center">
                            <i class="bx bx-check-circle me-2 fs-4"></i>
                            <div>
                                Send a minimum of
                                <strong><?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($plan->minimum)); ?></strong> worth of
                                <strong><?php echo e($wallet->name); ?></strong>
                                to the address below to complete your subscription.
                            </div>
                        </div>

                        <div class="row">

                            <!-- Payment Details -->
                            <div class="col-md-6 mb-4">

                                <div class="text-center mb-3">
                                    <img src="<?php echo e(asset($wallet->logo_path)); ?>" width="48" alt="<?php echo e($wallet->name); ?>">
                                </div>

                                <div class="text-center mb-3">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($wallet->qr_code_path): ?>
                                        <img class="img-fluid rounded border" src="<?php echo e(asset($wallet->qr_code_path)); ?>"
                                            alt="QR Code">
                                    <?php else: ?>
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo e($wallet->address); ?>"
                                            alt="QR Code" class="img-fluid rounded border">
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>

                                <!-- Wallet Address -->
                                <label class="form-label fw-semibold">Wallet Address</label>
                                <div class="input-group mb-3">
                                    <input type="text" value="<?php echo e($wallet->address); ?>" class="form-control" id="copyText"
                                        readonly>
                                    <button class="btn btn-outline-primary" type="button" id="copyButton">
                                        <i class="ti ti-copy"></i>
                                    </button>
                                </div>

                                <a href="<?php echo e(route('user.plan.payment.proof', [$plan->uuid, $wallet->uuid])); ?>">
                                    <button class="btn btn-success w-100">
                                        I Have Made This Payment
                                    </button>
                                </a>

                            </div>

                            <!-- Instructions -->
                            <div class="col-md-6">

                                <h5 class="fw-semibold mb-3">How to Make a Deposit</h5>
                                <p class="text-muted">
                                    Copy the company wallet address and paste it into the recipient field of your
                                    <?php echo e($wallet->name); ?> wallet application.
                                    You may also scan the QR code if you are using a mobile wallet.
                                </p>

                                <ul class="text-muted">
                                    <li>Ensure the correct network is selected</li>
                                    <li>Send the exact or higher amount required</li>
                                    <li>Transaction confirmation may take a few minutes</li>
                                </ul>

                                <hr>

                                <h5 class="fw-semibold mb-3">How to Buy <?php echo e($wallet->name); ?></h5>
                                <ol class="text-muted">
                                    <li>Create a <?php echo e($wallet->name); ?> wallet</li>
                                    <li>Select a trusted exchange</li>
                                    <li>Complete identity verification</li>
                                    <li>Add a payment method</li>
                                    <li>Purchase and transfer to your wallet</li>
                                </ol>

                                <p class="text-muted">
                                    Your wallet address functions like a bank account number.
                                    Always verify addresses before sending funds.
                                </p>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script>
        document.getElementById("copyButton").addEventListener("click", function() {
            const copyText = document.getElementById("copyText");
            navigator.clipboard.writeText(copyText.value);

            this.innerHTML = '<i class="ti ti-check"></i>';
            setTimeout(() => {
                this.innerHTML = '<i class="ti ti-copy"></i>';
            }, 1500);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/user/plan/payment.blade.php ENDPATH**/ ?>